package com.liquidnet.service.kylin.dto.vo.ignore;

import com.liquidnet.service.kylin.entity.KylinTicketTimes;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.format.DateTimeFormatter;

@Data
public class KylinTicketTimesIgnoreVo {

    @ApiModelProperty(value = "主键")
    private String ticketTimesId;
    @ApiModelProperty(value = "名称")
    private String title;
    @ApiModelProperty(value = "类型 1单日 2通票")
    private Integer type;
    @ApiModelProperty(value = "演出id")
    private String  performanceId;
    @ApiModelProperty(value = "场次id")
    private String timeId;
    @ApiModelProperty(value = "适用开始时间")
    private String useStart;
    @ApiModelProperty(value = "适用结束时间")
    private String useEnd;

//    @ApiModelProperty(value = "票种信息集合")
//    private List<TicketVo> ticketVoList;

    public void setTicketTimes(KylinTicketTimes ticketTimes){
        this.ticketTimesId=ticketTimes.getTicketTimesId();
        this.title=ticketTimes.getTitle();
        this.type=ticketTimes.getType();
        this.useStart=ticketTimes.getUseStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        this.useEnd=ticketTimes.getUseEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
}
