package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.kylin.task.FeignPlatformAlipayBackClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Platform
 */
@Component
public class PlatformTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(PlatformTaskHandler.class);

    @Autowired
    private FeignPlatformAlipayBackClient feignPlatformAlipayBackClient;

    @XxlJob(value = "sev-platform:alipayActiveCallbackHandler")
    public ReturnT<String> alipayActiveCallbackHandler() {
        try {
            String result = feignPlatformAlipayBackClient.alipayActiveCallback().getData();
            log.info("alipayActiveCallback：结果："+result);
            return ReturnT.SUCCESS;
        } catch (Exception e) {
            return ReturnT.FAIL;
        }
    }

}
