package com.liquidnet.service.platform.controller.basicServices;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.admin.ZhengzaiAppVersionsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 获取最新的正在现场App版本控制
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-09
 */
@Api(tags = "basicServices")
@RestController
@RequestMapping("basicServices/ZhengzaiAppVersions")
public class ZhengzaiAppVersionsController {

    @Autowired
    private RedisUtil redisUtil;

    @PostMapping("/last")
    @ApiOperation("获取最新版本信息")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "上传类型 1-IOS 2-Android", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "appType", value = "App类型 1-正在 2-验票", required = true),
//            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isProduction", value = "是否是生产环境，1是 2否", required = true),
    })
//    public ZhengzaiAppVersionsVo lastInfo(@RequestParam Integer type, @RequestParam Integer isProduction) {
    public ResponseDto<ZhengzaiAppVersionsVo> lastInfo(@RequestParam Integer type, @RequestParam Integer appType) {
        ZhengzaiAppVersionsVo info = null;
        if (1 == appType) {
            if (1 == type) {
                info = (ZhengzaiAppVersionsVo) redisUtil.get(KylinRedisConst.ZHENGZAI_APP_VERSIONS_IOS);
            } else if (2 == type) {
                info = (ZhengzaiAppVersionsVo) redisUtil.get(KylinRedisConst.ZHENGZAI_APP_VERSIONS_ANDROID);
            }
        } else if (2 == appType) {
            if (1 == type) {
                info = (ZhengzaiAppVersionsVo) redisUtil.get(KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_IOS);
            } else if (2 == type) {
                info = (ZhengzaiAppVersionsVo) redisUtil.get(KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_ANDROID);
            }
        }

        return ResponseDto.success(info);
    }

}
