package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

import java.util.ArrayList;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 分页拉取指定资产已授予碎片列表
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper012ListSdsByAstRespDto {
    public long requestId;
    public int errNo;
    public String errMsg;
    public ArrayList<ShardAssetInfo> list;
    public int hasMore;
    public String cursor;

    @Data
    public static class ShardAssetInfo {
        public long shardId;
        public String ownerAddr;
        public long price;
        public String txId;
        public String groupId;
        public long ctime;
    }

    private static final Xuper012ListSdsByAstRespDto obj = new Xuper012ListSdsByAstRespDto();
    public static Xuper012ListSdsByAstRespDto getNew() {
        try {
            return (Xuper012ListSdsByAstRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper012ListSdsByAstRespDto();
        }
    }
}
