package com.liquidnet.service.sweet.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@ApiModel(value = "SweetCityVoteParam", description = "用户投票记录入参")
@Data
public class SweetCityVoteParam implements java.io.Serializable {

    private static final long serialVersionUID = -2626425843975309892L;

    @ApiModelProperty(position = 10, required = true, value = "手机号", example = "15811009011")
    @NotBlank(message = "phone不能为空")
    private String phone;

    @ApiModelProperty(position = 11, required = true, value = "unionId", example = "unionId")
    @NotBlank(message = "unionId不能为空")
    private String unionId;

    @ApiModelProperty(position = 12, required = true, value = "城市代码", example = "10001")
    @NotBlank(message = "cityCode不能为空")
    private String cityCode;

    @ApiModelProperty(position = 13, required = true, value = "城市名称", example = "北京")
    @NotBlank(message = "cityName不能为空")
    private String cityName;

}
