package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.dto.SweetCityVoteStatDto;
import com.liquidnet.service.sweet.entity.SweetCityVote;
import com.liquidnet.service.sweet.mapper.SweetCityVoteMapper;
import com.liquidnet.service.sweet.mapper.SweetCityVoteStatMapper;
import com.liquidnet.service.sweet.param.SweetCityVoteParam;
import com.liquidnet.service.sweet.service.ISweetCityVoteService;
import com.liquidnet.service.sweet.utils.ObjectUtil;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetCItyVoteStatVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 答题表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-08-12
 */
@Service
public class SweetCityVoteServiceImpl extends ServiceImpl<SweetCityVoteMapper, SweetCityVote> implements ISweetCityVoteService {

    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    private SweetCityVoteStatMapper sweetCityVoteStatMapper;

    @Override
    public ResponseDto getList(String phone, String unionId) {
        List<SweetCItyVoteStatVo> sweetCityVoteStatList = redisDataUtils.getSweetCityVoteStatList();
        String userVote = redisDataUtils.getUserVote(phone, unionId);
        for (SweetCItyVoteStatVo info : sweetCityVoteStatList) {
            if (userVote.isEmpty()) {
                info.setIsVote(1);
            } else if (!userVote.equals(info.getCityCode())) {
                info.setIsVote(3);
            } else {
                info.setIsVote(2);
            }
        }
        HashMap<String, Object> stringObjectHashMap = CollectionUtil.mapStringObject();
        stringObjectHashMap.put("list", sweetCityVoteStatList);
        stringObjectHashMap.put("userVote", userVote);
        stringObjectHashMap.put("statUpdateTime", redisDataUtils.getSweetCityVoteStatUpdateTime());

        return ResponseDto.success(stringObjectHashMap);
    }

    @Override
    public ResponseDto createVote(SweetCityVoteParam param) {
        String userVote = redisDataUtils.getUserVote(param.getPhone(), param.getUnionId());
        if (!userVote.isEmpty()) {
            return ResponseDto.failure("已经投过票啦～");
        }
        SweetCityVote aNew = SweetCityVote.getNew();
        aNew.setVoteId(IDGenerator.nextSnowId());
        aNew.setPhone(param.getPhone());
        String sweetWechatOpenId = redisDataUtils.getSweetWechatOpenId(param.getUnionId());
        aNew.setOpenId(sweetWechatOpenId);
        aNew.setUnionId(param.getUnionId());
        aNew.setCityCode(param.getCityCode());
        aNew.setCityName(param.getCityName());


        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LinkedList<Object[]> sqlsDataB = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_city_vote.insert"));
        sqlsDataA.add(new Object[]{
                aNew.getVoteId(), aNew.getPhone(), sweetWechatOpenId, aNew.getUnionId(), aNew.getCityCode(), aNew.getCityName(), DateUtil.format(LocalDateTime.now(), DateUtil.Formatter.yyyyMMdd)
        });
        Integer cityVoteNum = redisDataUtils.getSweetCityVote(aNew.getCityCode());
        if (cityVoteNum > 0) { // 已有 incr
            sqls.add(SqlMapping.get("sweet_city_vote_stat.update"));
            sqlsDataB.add(new Object[]{
                    LocalDateTime.now(), aNew.getCityCode()
            });
        } else { // insert
            sqls.add(SqlMapping.get("sweet_city_vote_stat.insert"));
            sqlsDataB.add(new Object[]{
                    IDGenerator.nextSnowId(), aNew.getCityCode(), aNew.getCityName(), 1
            });
        }
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_CITY_VOTE_DRAW.getKey(),
                SqlMapping.gets(sqls, sqlsDataA, sqlsDataB));

        redisDataUtils.incrSweetCityVote(aNew.getCityCode());

        redisDataUtils.setUserVote(param.getPhone(), param.getUnionId(), param.getCityCode());

        return ResponseDto.success();
    }

    public ResponseDto setStatList() {
        List<SweetCityVoteStatDto> list = sweetCityVoteStatMapper.getStatList();
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<SweetCItyVoteStatVo> newList = ObjectUtil.getSweetCItyVoteStatVoList();
            list.forEach(r -> newList.add(SweetCItyVoteStatVo.getNew().copy(r)));
            redisDataUtils.setSweetCityVoteStatList(newList);
        }
        redisDataUtils.setSweetCityVoteStatUpdateTime();
        return ResponseDto.success();
    }
}
