-- 小程序订阅消息记录表
drop TABLE if exists `sweet_applet_sub_msg`;
CREATE TABLE `sweet_applet_sub_msg`
(
    `mid`           bigint unsigned NOT NULL AUTO_INCREMENT,
    `msg_id`        varchar(255)    NOT NULL DEFAULT '' COMMENT 'msg_id',
    `open_id`       varchar(255)    NOT NULL DEFAULT '' COMMENT 'open_id',
    `template_id`   varchar(255)    NOT NULL DEFAULT '' COMMENT 'template_id',
    `target_id`     varchar(255)    NOT NULL DEFAULT '' COMMENT '目标id 显示是演出id',
    `applet_type`   tinyint         NOT NULL DEFAULT 0 COMMENT '1草莓 2五百里 3mdsk 4正在 5跳飞船音乐节',
    `activity_type` tinyint         NOT NULL DEFAULT 0 COMMENT '活动类型',
    `is_push`       tinyint         NOT NULL DEFAULT 1 COMMENT '是否推送 1未推送 2已推送',
    `created_at`    datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`    datetime        NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY `sweet_applet_sub_msg_id` (`msg_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT '小程序订阅消息记录表';

alter table sweet_applet_sub_msg
    add union_id varchar(255) NOT NULL DEFAULT '' COMMENT 'union_id' after open_id;
alter table sweet_applet_sub_msg
    add user_id varchar(255) NOT NULL DEFAULT '' COMMENT 'user_id' after union_id;
ALTER TABLE sweet_applet_sub_msg
    MODIFY activity_type smallint NOT NULL DEFAULT 0 COMMENT '活动类型';