package com.liquidnet.service.feign.kylin.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.chime.config.SecuringRequestInterceptor;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.HashMap;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: FeignKylinForChimeClient
 * @Package com.liquidnet.service.feign.kylin.api
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/11 18:20
 */
@Component
@FeignClient(name = "liquidnet-service-kylin",
        contextId = "FeignKylinForChimeClient", path = "",
        url = "${liquidnet.service.kylin.url}",
        fallback = FallbackFactory.Default.class,
        configuration = SecuringRequestInterceptor.class)
public interface FeignKylinForChimeClient {
    @GetMapping("myPerformance/performancesList")
    ResponseDto<List<KylinPerformanceVo>> myPerformancesList();


    @GetMapping("performance/localList")
    ResponseDto<HashMap<String, Object>> localList(
            @RequestParam(value = "cityName",defaultValue = "") String cityName,
            @RequestParam(value = "days",defaultValue = "0") int days,
            @RequestParam(value = "type",defaultValue = "0") int type,

            @RequestParam(value = "isDiscount",defaultValue = "") Integer isDiscount,
            @RequestParam(value = "isAdvance",defaultValue = "") Integer isAdvance,
            @RequestParam(value = "isExclusive",defaultValue = "") Integer isExclusive,

            // 排序
            @RequestParam(value = "orderBy",defaultValue = "") String orderBy,
            @RequestParam(value = "sort",defaultValue = "") String sort
    );

//    @GetMapping(value = "/performance/list")
//    ResponseDto<List<KylinPerformanceVo>> performanceList(@RequestParam("performancesIds") String... performancesIds);

    @GetMapping("myPerformance/getDetail")
    ResponseDto<KylinPerformanceVo> getDetail(
            @RequestParam("performancesId") String performancesId
    );
}
