package com.liquidnet.service.sweet.controller;

import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.service.sweet.service.impl.SweetWechatMpService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.*;

@Api(tags = "同步微信用户数据")
@RestController
@RequestMapping("/wechatSync")
@Slf4j
public class SweetWechatSyncDataController {

    @Autowired
    private SweetWechatMpService sweetWechatMpService;

    @GetMapping("regMobile")
    @ApiOperation("注册")
    public void regMobile() throws IOException {
        String filePath = "/Users/jiangxiulong/Desktop/keys2.txt";
        String encoding = "UTF-8";
        File file = new File(filePath);
        if (file.isFile() && file.exists()) { //判断文件是否存在
            InputStreamReader read = new InputStreamReader(new FileInputStream(file), encoding);//考虑到编码格式
            BufferedReader bufferedReader = new BufferedReader(read);
            String mobile = null;
            while ((mobile = bufferedReader.readLine()) != null) {
                log.info("mobile：[{}]", mobile);
                try {
                    MultiValueMap<String, String> params = new LinkedMultiValueMap();
                    params.add("mobile", mobile);

//                    String url = "http://127.0.0.1:9001/adam/rsc/reg/mobile";
//                    String url = "http://adam.zhengzai.tv/adam/rsc/reg/mobile";
                    String url = "";
                    HttpUtil.post(url, params);
                } catch (Exception e) {
                    log.info("regMobileException：mobile：[{}]", mobile);
                }

            }
            read.close();
        } else {
            System.out.println("找不到指定的文件");
        }
    }

    @GetMapping("users")
    @ApiOperation("关注用户")
    public void getUsers() {
        try {
            sweetWechatMpService.userInfo();
        } catch (Exception e) {
            log.error("getUsers", e);
        }
    }

    @GetMapping("user")
    @ApiOperation("openid同步单个关注用户")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "openId", value = "openId", required = true)
    })
    public void getUser(@RequestParam() String openId) {
        try {
            sweetWechatMpService.getUser(openId);
        } catch (Exception e) {
            log.error("getUser", e);
        }
    }

}
