package com.liquidnet.service.platform.task.code;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExCodeVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExSkuVo;
import com.liquidnet.service.goblin.entity.GoblinGoodsSku;
import com.liquidnet.service.goblin.entity.GoblinNftExCode;
import com.liquidnet.service.goblin.entity.GoblinNftExCodeTask;
import com.liquidnet.service.goblin.mapper.GoblinGoodsSkuMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExCodeMapper;
import com.liquidnet.service.goblin.mapper.GoblinNftExCodeTaskMapper;
import com.liquidnet.service.goblin.param.GoblinNftExSkuParam;
import com.liquidnet.service.platform.utils.GoblinRedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Slf4j
@Configuration
@EnableScheduling
public class GoblinCodeTask {

    @Autowired
    private GoblinNftExCodeMapper goblinNftExCodeMapper;
    @Autowired
    GoblinNftExCodeTaskMapper goblinNftExCodeTaskMapper;
    @Autowired
    private GoblinGoodsSkuMapper goblinGoodsSkuMapper;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @Scheduled(cron = "0/5 * * * * ?") // 当前为同步  每隔5秒触发一次
    @Transactional(rollbackFor = Exception.class)
    public void scheduleCode() {
        /**
         * 获取所有定时任务列表
         */
        List<GoblinNftExCodeTask> goblinNftExCodeTasks = goblinNftExCodeTaskMapper.selectByActivity();

        if (goblinNftExCodeTasks.size() <= 0) {
            return;
        }


        Boolean bol = false;
        StringBuffer spuIds = new StringBuffer();
        for (GoblinNftExCodeTask goblinNftExCodeTask : goblinNftExCodeTasks) {
            if (goblinNftExCodeTask.getUnbox().equals("1")) {
                bol = true;
                spuIds.append(goblinNftExCodeTask.getSpuId()).append(",");
            }
        }


        // spu ---> sku集合
        Map<String, Map<String, BigDecimal>> spuMap = new HashMap<>();
        if (bol) {
            spuIds.deleteCharAt(spuIds.length() - 1);
            List<GoblinGoodsSku> goblinGoodsSkus = goblinGoodsSkuMapper.selectBySpuIds(spuIds.toString());
            for (GoblinGoodsSku goblinGoodsSku : goblinGoodsSkus) {
                if (goblinGoodsSku.getUnbox().equals("1")) {
                    continue;
                }

                if (spuMap.get(goblinGoodsSku.getSpuId()) == null) {
                    spuMap.put(goblinGoodsSku.getSpuId(), new HashMap<>());
                }

                if (getSkuAllStatusShow(goblinGoodsSku) && goblinRedisUtils.getSkuAllStatusStock(goblinGoodsSku) > 0 && goblinGoodsSku.getHitRatio() != null) {
                    spuMap.get(goblinGoodsSku.getSpuId()).put(goblinGoodsSku.getSkuId(), goblinGoodsSku.getHitRatio());
                }

            }
        }

        // sku ---> 兑换码关联
        Map<String, GoblinNftExCodeTask> goblinNftExCodeTaskHashMap = new HashMap<>();

        // 构建对象
        List<GoblinNftExCode> goblinNftExCodes = new ArrayList<>();

        // 当前时间
        LocalDateTime now = LocalDateTime.now();


        StringBuffer taskIds = new StringBuffer();
        for (GoblinNftExCodeTask goblinNftExCodeTask : goblinNftExCodeTasks) {

            taskIds.append(goblinNftExCodeTask.getTaskId()).append(",");
            switch (goblinNftExCodeTask.getUnbox()) {
                case "1":

                    // sku ---> 命中率
                    Map<String, BigDecimal> map = spuMap.get(goblinNftExCodeTask.getSpuId());

                    // sku ---> 库存
                    Map<String, Integer> skuMap = getSkuHitRatio(goblinNftExCodeTask.getExStock(), map);

                    for (String key : skuMap.keySet()) {

                        Integer stockNum = skuMap.get(key);

                        // 根据sku减库存
                        int stock = goblinRedisUtils.decrSkuStock(null, key, stockNum);
                        if (stock < 0) {
                            goblinRedisUtils.incrSkuStock(null, key, stockNum);
                        } else {
                            for (int k = 0; k < stockNum; k++) {
                                GoblinNftExCode goblinNftExCode = GoblinNftExCode.getNew();
                                goblinNftExCode.setCodeId(IDGenerator.nextSnowId());
                                goblinNftExCode.setActivityId(goblinNftExCodeTask.getActivityId());
                                // 兑换码
                                // 样例 2978-6496-9269-0694-XX
                                String code = IDGenerator.createCode(3, 4, true);
                                goblinNftExCode.setCode(code);
                                goblinNftExCode.setBoxSkuId(key);
                                goblinNftExCode.setState(1);
                                goblinNftExCode.setCreatedAt(now);
                                goblinNftExCodes.add(goblinNftExCode);


                                // 赋值额外属性
                                GoblinNftExCodeVo goblinNftExCodeVo = GoblinNftExCodeVo.getNew().copy(goblinNftExCode);
                                goblinNftExCodeVo.setExLimit(goblinNftExCodeTask.getExLimit());
                                goblinNftExCodeVo.setExStartTime(goblinNftExCodeTask.getExStartTime());
                                goblinNftExCodeVo.setExStopTime(goblinNftExCodeTask.getExStartTime());
                                goblinNftExCodeVo.setStoreId(goblinNftExCodeTask.getStoreId());
                                goblinNftExCodeVo.setSpuId(goblinNftExCodeTask.getSpuId());

                                LocalDateTime exStopTime = goblinNftExCodeTask.getExStopTime();
                                // 时间差  以秒表示
                                long millisNum = Duration.between(LocalDateTime.now(), exStopTime).toMillis();

                                // redis 存储
                                goblinRedisUtils.addCode(code, goblinNftExCodeVo, millisNum);
                                goblinNftExCode.setSkuId(goblinNftExCodeTask.getSkuId());

                            }

                            goblinNftExCodeTaskHashMap.put(key, goblinNftExCodeTask);
                        }

                    }
                    break;
                default:

                    // 根据sku减库存
                    int stock = goblinRedisUtils.decrSkuStock(null, goblinNftExCodeTask.getSkuId(), goblinNftExCodeTask.getExStock());
                    if (stock < 0) {
                        goblinRedisUtils.incrSkuStock(null, goblinNftExCodeTask.getSkuId(), goblinNftExCodeTask.getExStock());
                    } else {
                        for (int i = 0; i < goblinNftExCodeTask.getExStock(); i++) {
                            GoblinNftExCode goblinNftExCode = GoblinNftExCode.getNew();
                            goblinNftExCode.setCodeId(IDGenerator.nextSnowId());
                            goblinNftExCode.setActivityId(goblinNftExCodeTask.getActivityId());

                            // 获取兑换码ZA
                            // 样例 2978-6496-9269-0694-XX
                            String code = IDGenerator.createCode(3, 4, true);
                            goblinNftExCode.setCode(code);
                            goblinNftExCode.setSkuId(goblinNftExCodeTask.getSkuId());
                            goblinNftExCode.setState(1);
                            goblinNftExCode.setCreatedAt(now);
                            goblinNftExCodes.add(goblinNftExCode);

                            // 赋值额外属性
                            GoblinNftExCodeVo goblinNftExCodeVo = GoblinNftExCodeVo.getNew().copy(goblinNftExCode);
                            goblinNftExCodeVo.setExLimit(goblinNftExCodeTask.getExLimit());
                            goblinNftExCodeVo.setExStartTime(goblinNftExCodeTask.getExStartTime());
                            goblinNftExCodeVo.setExStopTime(goblinNftExCodeTask.getExStartTime());
                            goblinNftExCodeVo.setStoreId(goblinNftExCodeTask.getStoreId());
                            goblinNftExCodeVo.setSpuId(goblinNftExCodeTask.getSpuId());


                            LocalDateTime exStopTime = goblinNftExCodeTask.getExStopTime();
                            // 时间差  以秒表示
                            long millisNum = Duration.between(LocalDateTime.now(), exStopTime).toMillis();

                            // redis 存储
                            goblinRedisUtils.addCode(code, goblinNftExCodeVo, millisNum);

                        }

                        GoblinNftExCodeTask nftExCodeTask = goblinNftExCodeTaskHashMap.get(goblinNftExCodeTask.getSkuId());
                        if (nftExCodeTask == null) {
                            goblinNftExCodeTaskHashMap.put(goblinNftExCodeTask.getSkuId(), goblinNftExCodeTask);
                        }

                    }
            }

        }


        /**
         * sku redis 时间存储
         */
        for (String key : goblinNftExCodeTaskHashMap.keySet()) {

            GoblinNftExSkuVo goblinNftExSkuVo = goblinRedisUtils.getSkuTime(key);

            GoblinNftExCodeTask goblinNftExCodeTask = goblinNftExCodeTaskHashMap.get(key);


            LocalDateTime exStartTime = goblinNftExCodeTask.getExStartTime(); // "2022-06-26 19:00:00";
            LocalDateTime exStopTime = goblinNftExCodeTask.getExStopTime(); // "2024-06-26 19:00:00";
            if (!StringUtil.isEmpty(goblinNftExSkuVo)) {
                // redis存储 单个sku的开始和结束时间
                LocalDateTime rdExStartTime = LocalDateTime.parse(goblinNftExSkuVo.getRdStartTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")); // "2019-06-26 19:00:00";
                LocalDateTime rdExStopTime = LocalDateTime.parse(goblinNftExSkuVo.getRdStopTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")); // "2019-06-26 19:00:00";
                // 时间比对
                if (!rdExStartTime.isAfter(exStartTime)) {
                    exStartTime = rdExStartTime;
                }

                if (rdExStopTime.isAfter(exStopTime)) {
                    exStopTime = rdExStopTime;
                }
            }

            GoblinNftExSkuVo goblinNftExSku = GoblinNftExSkuVo.getNew();
            goblinNftExSku.setExStartTime(exStartTime);
            goblinNftExSku.setExStopTime(exStopTime);
            goblinNftExSku.setRdStartTime(exStartTime.toString());
            goblinNftExSku.setRdStopTime(exStopTime.toString());
            goblinRedisUtils.addSkuTime(key, goblinNftExSku);
        }

        long startm = System.currentTimeMillis();
        goblinNftExCodeMapper.addGoblinNftExCodes(goblinNftExCodes);

        // 修改定时
        goblinNftExCodeTaskMapper.updateByTaskIds(taskIds.toString());
        log.debug("MSQ耗时：ms", System.currentTimeMillis() - startm);

    }


    /**
     * 获取每个sku的兑换码生成数量
     *
     * @param exStock
     * @param map
     * @return
     */
    private Map<String, Integer> getSkuHitRatio(Integer exStock, Map<String, BigDecimal> map) {

        // sku ---> 次数
        Map<String, Integer> skuNumMap = new HashMap<>();

        for (String key : map.keySet()) {

            if (map.get(key) == null) {
                System.out.println(map.get(key));
            }
            // 概率
            BigDecimal hitNum = map.get(key).divide(BigDecimal.valueOf(100)).setScale(2, BigDecimal.ROUND_HALF_UP);
            Integer stock = hitNum.multiply(BigDecimal.valueOf(exStock)).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
            skuNumMap.put(key, stock);
        }
        return skuNumMap;
    }


    // 各种状态下判断藏品是否可以展示
    public boolean getSkuAllStatusShow(GoblinGoodsSku info) {
        if (info != null
                && info.getSkuType() == 1
                && info.getStatus().equals("3")
                && info.getShelvesStatus().equals("3")
                && (info.getSkuAppear() == null || info.getSkuAppear().equals("0"))
                && info.getDelFlg().equals("0")
                && info.getUnbox().equals("0")) {
            return true;
        } else {
            return false;
        }
    }


}