package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单状态
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderTicketStatus implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * order_ticket_status_id
     */
    private String orderTicketStatusId;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 快递方式 1寄付 2到付
     */
    private Integer expressType;

    /**
     * 转移状态，0未转移，1收到他人转赠，2已转赠给他人
     */
    private Integer transferStatus;

    /**
     * 订单状态:0待付款，1已付款，2已关闭，3正在退款，4已退款, 5待关闭 6部分退款
     */
    private Integer status;

    /**
     * 支付状态:0未支付 1已支付 2支付失败
     */
    private Integer payStatus;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;


}
