package com.liquidnet.service.dragon.service.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.channel.strategy.PayChannelStrategyContext;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.service.IDragonOrdersService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.HashMap;

@Slf4j
@Service
public class DragonOrdersServiceImpl implements IDragonOrdersService {
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Autowired
    private PayChannelStrategyContext payChannelStrategyContext;

    @Override
    public void sendRedisQueue() {
        try {
            HashMap<String ,String> map = new HashMap<>();
            map.put("message","测试 redis 订阅信息1");
            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey("dragon-pay");
            stringRedisTemplate.opsForStream().add(record);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public ResponseDto<DragonPayBaseRespDto> dragonPay(DragonPayBaseReqDto dragonPayBaseReqDto) {
        return payChannelStrategyContext.getStrategy(dragonPayBaseReqDto.getPayType()).dragonPay(dragonPayBaseReqDto);
    }
}
