package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtGoodsActionParam", description = "商品管理:商品列表操作入参")
@Data
public class GoblinStoreMgtGoodsSkuActionParam implements Serializable {
    private static final long serialVersionUID = 6564996671833040261L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "商品ID[64]")
    @NotBlank(message = "商品ID不能为空")
    private String spuId;
    @ApiModelProperty(position = 12, required = true, value = "操作类型[ONSHELVES-上架|UNSHELVE-下架|REMOVE-删除]")
    @Pattern(regexp = "\\b(ONSHELVES|UNSHELVE|REMOVE)\\b", message = "操作类型无效")
    private String action;
    @ApiModelProperty(position = 13, required = true, value = "单品ID列表")
    private List<String> skuIdList;
}
