package com.liquidnet.client.admin.web.controller.zhengzai.slime;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeFieldAppliesAdminService;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeFieldsAdminService;
import com.liquidnet.service.slime.dto.param.admin.SlimeFieldApplyListParam;
import com.liquidnet.service.slime.dto.vo.SlimeFieldAppliesVo;
import com.liquidnet.service.slime.dto.vo.SlimeFieldsVo;
import com.liquidnet.service.slime.entity.SlimeFieldApplies;
import com.liquidnet.service.slime.entity.SlimeFields;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;


@Api(tags = "场地申请管理")
@Controller
@RequestMapping("slime/field/apply")
public class SlimeFieldAppliesController extends BaseController {

    private final String prefix = "zhengzai/kylin/field";

    @Autowired
    ISlimeFieldsAdminService slimeFieldsAdminService;

    @Autowired
    ISlimeFieldAppliesAdminService slimeFieldAppliesAdminService;


    @GetMapping()
    public String applyList() {
        return prefix + "/applyList";
    }


    @Log(title = "场地申请列表", businessType = BusinessType.LIST)
    @RequiresPermissions("slime:field:apply")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(SlimeFieldApplyListParam param) {
        startPage();
        return getDataTable(slimeFieldAppliesAdminService.list(
                Wrappers.lambdaQuery(SlimeFieldApplies.class)
                        .eq(param.getFieldApplyId().length() > 0, SlimeFieldApplies::getFieldApplyId, param.getFieldApplyId())
                        .eq(param.getApplyStatus() >= 0, SlimeFieldApplies::getApplyStatus, param.getApplyStatus())
                        .eq(!param.getApplyType().equals("all"), SlimeFieldApplies::getApplyType, param.getApplyType())
                        .select(
                                SlimeFieldApplies::getFieldApplyId, SlimeFieldApplies::getApplyStatus, SlimeFieldApplies::getApplyType, SlimeFieldApplies::getReject, SlimeFieldApplies::getUid, SlimeFieldApplies::getFieldId,
                                SlimeFieldApplies::getName, SlimeFieldApplies::getLogo,
                                SlimeFieldApplies::getCreatedAt
                        )
        ));
    }

    @Log(title = "场地申请详情", businessType = BusinessType.DETAIL)
    @RequiresPermissions("slime:field:apply")
    @GetMapping("/details/{fieldApplyId}")
    public String detail(@PathVariable("fieldApplyId") String fieldApplyId, ModelMap mmap) {

        LambdaQueryWrapper<SlimeFieldApplies> fieldAppliesLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeFieldApplies.class);
        fieldAppliesLambdaQueryWrapper.eq(SlimeFieldApplies::getFieldApplyId, fieldApplyId);
        SlimeFieldApplies fieldApplies = slimeFieldAppliesAdminService.getOne(fieldAppliesLambdaQueryWrapper);

        SlimeFieldAppliesVo fieldAppliesVo = SlimeFieldAppliesVo.getNew();
        fieldAppliesVo.copy(fieldApplies);
        if (fieldAppliesVo.getApplyType().equals("claim")) {
            LambdaQueryWrapper<SlimeFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeFields.class);
            fieldsLambdaQueryWrapper.eq(SlimeFields::getFieldId, fieldAppliesVo.getFieldId());
            SlimeFields fields = slimeFieldsAdminService.getOne(fieldsLambdaQueryWrapper);

            SlimeFieldsVo fieldsVo = SlimeFieldsVo.getNew();
            fieldsVo.copy(fields);
            fieldAppliesVo.setFieldVo(fieldsVo);
        }

        mmap.put("fieldApplyInfo", fieldAppliesVo);

        return prefix + "/applyDetail";
    }

    @ApiOperation(value = "审核通过")
    @Log(title = "场地申请审核通过", businessType = BusinessType.INSERT)
    @RequiresPermissions("slime:field:apply")
    @PostMapping("/approve")
    @ResponseBody
    public AjaxResult approve(@RequestParam(required = true) String fieldApplyId) {
        String authUid = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();

        return toAjax(slimeFieldAppliesAdminService.applyApprove(fieldApplyId, authUid, authName));
    }

    @ApiOperation(value = "审核驳回")
    @Log(title = "场地申请审核驳回", businessType = BusinessType.INSERT)
    @RequiresPermissions("slime:field:apply")
    @PostMapping("/reject")
    @ResponseBody
    public AjaxResult reject(@RequestParam(required = true) String fieldApplyId,
                             @RequestParam(required = true) String reject) {
        String authUid = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();

        return toAjax(slimeFieldAppliesAdminService.applyReject(fieldApplyId, authUid, authName, reject));
    }
}
