package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinStoreMgtCouponListVo", description = "商铺活动:优惠券列表信息")
@Data
public class GoblinStoreMgtCouponListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -8794122053242926547L;
    @ApiModelProperty(position = 10, value = "卡券ID[64]")
    private String storeCouponId;
    @ApiModelProperty(position = 11, value = "卡券编码[64]")
    private String storeCouponNo;
    @ApiModelProperty(position = 12, value = "卡券名称[50]")
    private String title;
    @ApiModelProperty(position = 13, value = "卡券状态[0-等待开始|1-活动中|2-活动结束|3-停用]")
    private String state;
    @ApiModelProperty(position = 14, value = "库存")
    private Integer stock;
    @ApiModelProperty(position = 15, value = "领取数量")
    private Integer receiveNum;
    @ApiModelProperty(position = 16, value = "使用数量")
    private Integer usedNum;
    @ApiModelProperty(position = 17, value = "开始时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime startTime;
    @ApiModelProperty(position = 18, value = "结束时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime endTime;
    @ApiModelProperty(position = 19, value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;


    @ApiModelProperty(position = 20, value = "已领取库存")
    private Integer receiveStock;
    @ApiModelProperty(position = 21, value = "已使用库存")
    private Integer usedStock;
}
