package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxySeriesInfoBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 15:03
 */
@Data
public class GalaxySeriesInfoBo implements Serializable,Cloneable {
    /**
     * 本地系列唯一标识id
     */
    private String seriesInfoId;
    /**
     * 本地系列唯一名称(前缀+skuid)
     */
    private String seriesName;
    /**
     * 本地系列唯一编码
     */
    private String seriesCode;
    /**
     * 区块链上系列ID(系列声明后获取,NFT发行购买用到)
     */
    private String seriesId;
    /**
     * 系列发行总量
     */
    private Long totalCount;
    /**
     * 系列已发行个数
     */
    private Long crtCount;
    /**
     * 系列声明任务ID
     */
    private String seriesClaimTaskId;
    /**
     * 系列声明状态
     */
    private String seriesClaimStatus;

    /**
     * 系列显示封面
     */
    private String coverUrl;

    /**
     * 系列描述信息，不超过500个字符
     */
    private String seriesDesc;

    /**
     * 系列声明时间
     */
    private String chainTimestamp;

    /**
     * 系列链上交易hash
     */
    private String tradeHash;

    /**
     * 系列声明中nftHash
     */
    private Integer nftCount;

    /**
     * 路由类型
     */
    private String routerType;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;
    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxySeriesInfoBo obj = new GalaxySeriesInfoBo();

    public static GalaxySeriesInfoBo getNew() {
        try {
            return (GalaxySeriesInfoBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxySeriesInfoBo();
        }
    }
}
