package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.dto.param.SweetAntigenicQuestionParam;
import com.liquidnet.service.sweet.entity.SweetAntigenicQuestion;
import com.liquidnet.service.sweet.mapper.SweetAntigenicQuestionMapper;
import com.liquidnet.service.sweet.service.ISweetAntigenicQuestionService;
import com.liquidnet.service.sweet.utils.QueueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.LinkedList;

/**
 * <p>
 * 防疫答题表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-28
 */
@Service
public class SweetAntigenicQuestionServiceImpl extends ServiceImpl<SweetAntigenicQuestionMapper, SweetAntigenicQuestion> implements ISweetAntigenicQuestionService {

    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<Boolean> create(SweetAntigenicQuestionParam param) {
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_antigenic_question.insert"));
        sqlsDataA.add(new Object[]{
                IDGenerator.nextSnowId(), param.getType(), param.getOpenId(), param.getUnionId(), param.getNickname(), param.getAddress(), param.getPhone(),
                param.getUrgentPhone(), param.getKeyword1(), param.getKeyword11(), param.getKeyword2(), param.getKeyword3(), param.getKeyword4(), param.getKeyword5(),
                param.getKeyword6(), param.getKeyword7()
        });
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_ANTIGENIC_QUESTION.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));
        return ResponseDto.success();
    }
}
