package com.liquidnet.service.galaxy.dto;

import com.liquidnet.service.galaxy.dto.param.GalaxyQueryUserTradeAllListRespDto;
import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TradeInfo
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/23 13:43
 */
@Data
public class TradeInfoDto {
    /**
     * 藏品缩略图
     */
    private String displayUrl;
    /**
     * 系列缩略图
     */
    private String coverUrl;
    /**
     * 藏品hash
     */
    private String hash;
    /**
     * nftId
     */
    private String nftId;
    /**
     * 藏品名称
     */
    private String name;
    /**
     * 发行时间
     */
    private String publishTime;
    /**
     * 藏品url
     */
    private String url;
    /**
     * 交易时间
     */
    private String dealTime;
    /**
     * 成交金额
     */
    private Long dealCount;
    /**
     * 转入地址
     */
    private String fromAddr;
    /**
     * 转出地址
     */
    private String toAddr;
    /**
     * 交易类别， 1:发行 2:购买 3:转移 4:设置价格 5:设置状态
     */
    private Integer txType;

    private static final TradeInfoDto obj = new TradeInfoDto();

    public static TradeInfoDto getNew() {
        try {
            return (TradeInfoDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new TradeInfoDto();
        }
    }
}
