package com.liquidnet.service.sweet.dto.vo;

import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrizeRelation;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class IntegralActivityPrizeRelationVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -303399210433737206L;

    @ApiModelProperty(value = "prize_relation_id")
    private String prizeRelationId;

    @ApiModelProperty(value = "prize_id")
    private String prizeId;

    @ApiModelProperty(value = "券id")
    private String couponId;

    @ApiModelProperty(value = "券名称")
    private String couponTitle;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updatedAt;

    private static final IntegralActivityPrizeRelationVo obj = new IntegralActivityPrizeRelationVo();
    public static IntegralActivityPrizeRelationVo getNew() {
        try {
            return (IntegralActivityPrizeRelationVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new IntegralActivityPrizeRelationVo();
        }
    }

    public IntegralActivityPrizeRelationVo copy(SweetIntegralActivityPrizeRelation source) {
        if (null == this) return this;
        this.setPrizeRelationId(source.getPrizeRelationId());
        this.setPrizeId(source.getPrizeId());
        this.setCouponId(source.getCouponId());
        this.setCouponTitle(source.getCouponTitle());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

}
