package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 限购错误结果VO
 */
@ApiModel("限购错误结果VO")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LimitErrorResultVo {

    /**
     * 限购类型
     */
    @ApiModelProperty("限购类型：1-演出，2-票种，3-场次")
    private Integer limitType;

    /**
     * 限购对象
     */
    @ApiModelProperty("限购对象：1-账户，2-实名")
    private Integer limitTarget;

    /**
     * 限购数量
     */
    @ApiModelProperty("限购数量")
    private Integer limitCount;

    /**
     * 当前已购买数量
     */
    @ApiModelProperty("当前已购买数量")
    private Integer currentCount;

    /**
     * 会员逻辑
     */
    @ApiModelProperty("0全员 2会员专属 1会员时间段")
    private Integer memberType;

    /**
     * 演出 id
     */
    @ApiModelProperty("演出 id")
    private String performancesId;

    /**
     * 票种 id
     */
    @ApiModelProperty("票种 id")
    private String ticketsId;

    /**
     * 场次 id
     */
    @ApiModelProperty("场次 id")
    private String timeId;

    /**
     * 身份证
     */
    @ApiModelProperty("身份证")
    private String idCard;

    /**
     * 姓名
     */
    @ApiModelProperty("姓名")
    private String idName;

    /**
     * 入场人 id
     */
    @ApiModelProperty("入场人 id")
    private String entersId;

    /**
     * 错误信息
     */
    @ApiModelProperty("错误信息")
    private String errorMessage;

}