package com.liquidnet.service.slime.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.slime.entity.SlimeSponsorApplies;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel(value = "SlimeSponsorAppliesVo", description = "申请的主办")
@Data
public class SlimeSponsorAppliesVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -4495918133684950796L;

    @ApiModelProperty(position = 10, value = "主办申请ID")
    private String sponsorApplyId;
    @ApiModelProperty(position = 11, value = "主办申请状态 0-待审核 1-通过 2-驳回")
    private Integer applyStatus;
    @ApiModelProperty(position = 12, value = "主办申请类型 create-创建")
    private String applyType;
    @ApiModelProperty(position = 13, value = "驳回原因")
    private String reject;
    @ApiModelProperty(position = 14, value = "用户ID")
    private String uid;

    @ApiModelProperty(position = 15, value = "主办ID，通过后存在")
    private String sponsorId;
    @ApiModelProperty(position = 16, value = "主办，通过后存在")
    private SlimeSponsorsVo sponsorVo;

    @ApiModelProperty(position = 17, value = "主办名称")
    private String name;
    @ApiModelProperty(position = 18, value = "logo图片地址")
    private String logo;
    @ApiModelProperty(position = 19, value = "背景图片地址")
    private String background;
    @ApiModelProperty(position = 20, value = "介绍")
    private String description;

    @ApiModelProperty(position = 21, value = "联系人姓名")
    private String contactName;
    @ApiModelProperty(position = 22, value = "联系人身份证号码")
    private String contactIdentity;
    @ApiModelProperty(position = 23, value = "联系人身份证正面照")
    private String contactIdentityObverse;
    @ApiModelProperty(position = 24, value = "联系人身份证反面照")
    private String contactIdentityReverse;
    @ApiModelProperty(position = 25, value = "联系人邮箱")
    private String contactEmail;

    @ApiModelProperty(position = 26, value = "企业名称")
    private String companyName;
    @ApiModelProperty(position = 27, value = "营业执照编号")
    private String licenseCode;
    @ApiModelProperty(position = 28, value = "营业执照图片地址")
    private String licenseImg;

    @ApiModelProperty(position = 29, value = "法人姓名")
    private String legalName;
    @ApiModelProperty(position = 30, value = "法人身份证号码")
    private String legalIdentity;
    @ApiModelProperty(position = 31, value = "法人身份证正面照")
    private String legalIdentityObverse;
    @ApiModelProperty(position = 32, value = "法人身份证反面照")
    private String legalIdentityReverse;

    @ApiModelProperty(position = 33, value = "审核人ID")
    private String auditUid;
    @ApiModelProperty(position = 34, value = "审核人姓名")
    private String auditName;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime auditedAt;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime deletedAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;


    private static final SlimeSponsorAppliesVo obj = new SlimeSponsorAppliesVo();

    public static SlimeSponsorAppliesVo getNew() {
        try {
            return (SlimeSponsorAppliesVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new SlimeSponsorAppliesVo();
    }

    public SlimeSponsorAppliesVo copy(SlimeSponsorApplies source) {
        if (null == source) return this;

        this.setSponsorApplyId(source.getSponsorApplyId());
        this.setApplyStatus(source.getApplyStatus());
        this.setApplyType(source.getApplyType());
        this.setReject(source.getReject());
        this.setUid(source.getUid());

        this.setSponsorId(source.getSponsorId());

        this.setName(source.getName());
        this.setLogo(source.getLogo());
        this.setBackground(source.getBackground());
        this.setDescription(source.getDescription());

        this.setContactName(source.getContactName());
        this.setContactIdentity(source.getContactIdentity());
        this.setContactIdentityObverse(source.getContactIdentityObverse());
        this.setContactIdentityReverse(source.getContactIdentityReverse());
        this.setContactEmail(source.getContactEmail());

        this.setCompanyName(source.getCompanyName());
        this.setLicenseCode(source.getLicenseCode());
        this.setLicenseImg(source.getLicenseImg());

        this.setLegalName(source.getLegalName());
        this.setLegalIdentity(source.getLegalIdentity());
        this.setLegalIdentityObverse(source.getLegalIdentityObverse());
        this.setLegalIdentityReverse(source.getLegalIdentityReverse());

        this.setAuditUid(source.getAuditUid());
        this.setAuditName(source.getAuditName());
        this.setAuditedAt(source.getAuditedAt());

        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        this.setDeletedAt(source.getDeletedAt());

        return this;
    }
}
