package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 充值金额选项表
 * </p>
 *
 * @author jiangxiulong
 * @since 2025-07-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinRechargeAmount implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 金额ID
     */
    private String amountId;

    /**
     * 金额名称
     */
    private String name;

    /**
     * 充值金额
     */
    private BigDecimal price;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
