package com.liquidnet.client.admin.web.controller.zhengzai.candy;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.candy.dto.CandyCouponCodeExcelDto;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponCodeAdminService;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.candy.constant.CandyRedisConst;
import com.liquidnet.service.candy.dto.CandyCouponCodeDto;
import com.liquidnet.service.candy.dto.admin.CandyCouponCodeListParam;
import com.liquidnet.service.candy.dto.admin.CandyCouponCodeOptParam;
import com.liquidnet.service.candy.entity.CandyCouponCode;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Api(tags = "券码管理")
@Controller
@RequestMapping("candy/coupon/code")
public class CandyCouponCodeAdminController extends BaseController {
    private String prefix = "zhengzai/candy/coupon/code";

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ICandyCouponCodeAdminService candyCouponCodeAdminService;

    @RequiresPermissions("candy:coupon:code:view")
    @GetMapping()
    public String view(@RequestParam String couponId, ModelMap mmap) {
        mmap.put("couponId", couponId);
        return prefix + "/code";
    }

    @RequiresPermissions("candy:coupon:code:list")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(CandyCouponCodeListParam listParam) {
        startPage();
        return getDataTable(listQuery(listParam));
    }

    private List<CandyCouponCode> listQuery(CandyCouponCodeListParam listParam) {
        LambdaQueryWrapper<CandyCouponCode> lambdaQuery = Wrappers.lambdaQuery(CandyCouponCode.class);
        lambdaQuery.eq(CandyCouponCode::getCouponId, listParam.getCouponId())
                .ne(CandyCouponCode::getState, 2)
                .select(
                        CandyCouponCode::getCcode,
                        CandyCouponCode::getCouponId,
                        CandyCouponCode::getRedeemMobile,
                        CandyCouponCode::getState
                );
        if (null != listParam.getState()) {
            lambdaQuery.eq(CandyCouponCode::getState, listParam.getState());
        }
        return candyCouponCodeAdminService.list(lambdaQuery);
    }

    @RequiresPermissions("candy:coupon:code:export")
    @PostMapping("export")
    @ResponseBody
    public AjaxResult export(CandyCouponCodeListParam listParam) {
        List<CandyCouponCode> list = listQuery(listParam);

        ExcelUtil<CandyCouponCodeExcelDto> excelUtil = new ExcelUtil<>(CandyCouponCodeExcelDto.class);
        List<CandyCouponCodeExcelDto> excelList = new ArrayList<>();
        list.forEach(r -> {
            excelList.add(CandyCouponCodeExcelDto.getNew().copy(r));
        });
        return excelUtil.exportExcel(excelList, "券码数据");
    }

    @RequiresPermissions("candy:coupon:code:invalid")
    @PostMapping("invalid")
    @ResponseBody
    public AjaxResult invalid(CandyCouponCodeOptParam optParam) {
        logger.debug("optParam:{}", JsonUtils.toJson(optParam));

        optParam.getCcodes().forEach(r -> {
            String key = CandyRedisConst.BASIC_COUPON_CODE.concat(r);
            CandyCouponCodeDto dto = (CandyCouponCodeDto) redisUtil.get(key);
            if (null != dto) {
                dto.setState(4);
                redisUtil.set(key, dto);
            }
        });

        LambdaUpdateWrapper<CandyCouponCode> couponCodeUpdateWrapper = Wrappers.lambdaUpdate(CandyCouponCode.class);
        couponCodeUpdateWrapper.in(CandyCouponCode::getCcode, optParam.getCcodes()).eq(CandyCouponCode::getCouponId, optParam.getCouponId());

        CandyCouponCode updateCouponCode = new CandyCouponCode();
        updateCouponCode.setState(4);
        updateCouponCode.setUpdatedAt(LocalDateTime.now());
        return toAjax(candyCouponCodeAdminService.update(updateCouponCode, couponCodeUpdateWrapper));
    }

    @RequiresPermissions("candy:coupon:code:recover")
    @PostMapping("recover")
    @ResponseBody
    public AjaxResult recover(CandyCouponCodeOptParam optParam) {
        logger.debug("optParam:{}", JsonUtils.toJson(optParam));

        optParam.getCcodes().forEach(r -> {
            String key = CandyRedisConst.BASIC_COUPON_CODE.concat(r);
            CandyCouponCodeDto dto = (CandyCouponCodeDto) redisUtil.get(key);
            if (null != dto) {
                dto.setState(5);
                redisUtil.set(key, dto);
            }
        });

        LambdaUpdateWrapper<CandyCouponCode> couponCodeUpdateWrapper = Wrappers.lambdaUpdate(CandyCouponCode.class);
        couponCodeUpdateWrapper.in(CandyCouponCode::getCcode, optParam.getCcodes()).eq(CandyCouponCode::getCouponId, optParam.getCouponId());

        CandyCouponCode updateCouponCode = new CandyCouponCode();
        updateCouponCode.setState(5);
        updateCouponCode.setUpdatedAt(LocalDateTime.now());
        return toAjax(candyCouponCodeAdminService.update(updateCouponCode, couponCodeUpdateWrapper));
    }
}
