package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户 收藏/喜欢等状态
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetUserRelation implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 类型 1喜欢艺人  2签售艺人
     */
    private Integer type;

    /**
     * 目标id
     */
    private Integer targetId;

    /**
     * 手册id
     */
    private Integer manualId;

    /**
     * 1是 0否
     */
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
