package com.liquidnet.service.sweet.config;

import com.liquidnet.common.web.config.WebMvcConfig;
import com.liquidnet.common.web.filter.GlobalAuthorityInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

@Configuration
public class StoneWebMvcConfig extends WebMvcConfig {
    @Autowired
    GlobalAuthorityInterceptor globalAuthorityInterceptor;

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(globalAuthorityInterceptor).addPathPatterns("/**");
        super.addInterceptors(registry);
    }
}
