package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetRichtext;
import com.liquidnet.service.sweet.entity.SweetStage;
import com.liquidnet.service.sweet.service.ISweetRichtextService;
import com.liquidnet.service.sweet.service.ISweetStageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 电子宣传手册富文本表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Api(tags = "电子手册 富文本")
@RestController
@RequestMapping("/sweet-richtext")
public class SweetRichtextController {

    @Autowired
    ISweetRichtextService sweetRichtextService;

    @GetMapping("get")
    @ApiOperation("富文本详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "类型 (1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略)", required = true),
    })
    public ResponseDto<SweetRichtext> get(@RequestParam(defaultValue = "1") String manualId,
                                          @RequestParam(defaultValue = "1") Integer type) {
        return sweetRichtextService.get(manualId, type);
    }

    @GetMapping("list")
    @ApiOperation("添加富文本")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "manualId", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "details", value = "数量", required = false),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "local", value = "经纬度 经度,维度，", required = false),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "picUrl", value = "图片地址", required = false),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "类型 (1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略)", required = true),
    })
    public ResponseDto<Boolean> add(@RequestParam(defaultValue = "1") String manualId,
                                    @RequestParam(defaultValue = "",required = false) String details,
                                    @RequestParam(defaultValue = "100.100,200.200",required = false) String local,
                                    @RequestParam(defaultValue = "",required = false) String picUrl,
                                    @RequestParam(defaultValue = "1") Integer type) {
        return sweetRichtextService.add(manualId, details, local, picUrl, type);
    }

    @PostMapping("change")
    @ApiOperation("修改富文本")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "manualId", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "details", value = "数量", required = false),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "local", value = "经纬度 经度,维度，", required = false),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "picUrl", value = "图片地址", required = false),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "类型 (1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略)", required = true),
    })
    public ResponseDto<Boolean> change(@RequestParam(defaultValue = "1") String manualId,
                                       @RequestParam(defaultValue = "",required = false) String details,
                                       @RequestParam(defaultValue = "100.100,200.200",required = false) String local,
                                       @RequestParam(defaultValue = "",required = false) String picUrl,
                                       @RequestParam(defaultValue = "1") Integer type) {
        return sweetRichtextService.change(manualId, details, local, picUrl, type);
    }

}
