package com.liquidnet.client.admin.web.controller.zhengzai.tools;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderExportVo;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderOutLineVo;
import com.liquidnet.client.admin.zhengzai.kylin.service.IExportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Controller
@RequestMapping("/tools")
public class ToolsBaseController extends BaseController {

    private String prefix = "zhengzai/tools";
    @Autowired
    private IExportService exportService;

    @GetMapping()
    public String tools() {
        return prefix + "/tools";
    }

    @GetMapping(value = "/details/{id}")
    public String detailsRoadShow(@PathVariable("id") Integer id, ModelMap mmap) {
        if (id == 1) {
            mmap.put("url", "/tools/export/mobile");
            return prefix + "/fun1";
        } else {
            return prefix + "/edit";
        }
    }

    @PostMapping("/export/mobile")
    @ResponseBody
    public AjaxResult exportMobile(Integer mobileType, String performanceId) {
        if (performanceId == null || performanceId.trim().equals("")) {
            return error("演出id有误");
        }

        List<OrderExportVo> list;
        if (mobileType == 1) {//购票用户
            list = exportService.exportOrderByPerformanceIdPay(performanceId);
        } else if (mobileType == 2) {//下单用户
            list = exportService.exportOrderByPerformanceIdAll(performanceId);
        } else {
            return error("查无订单");
        }
        if (list.size() == 0) {
            return error("查无订单");
        }
        ExcelUtil<OrderExportVo> util = new ExcelUtil(OrderExportVo.class);
        return util.exportExcel(list, list.get(0).getPerformanceTitle() + "-" + mobileType);
    }
}
