package com.liquidnet.service.bank.currencycloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "transaction query")
public class BankCcTransactionQuery {

    @ApiModelProperty(value = "contactId")
    private String contactId;

    @ApiModelProperty(value = "Three-digit currency code.")
    private String currency;

    @ApiModelProperty(value = "Amount.")
    private String amount;

    @ApiModelProperty(
            value = "The action that triggered the transaction."
            , allowableValues = "funding,conversion,payment,payment_failure,manual_intervention,manual_transaction,top_up_fee,transfer,conversion_deposit,deposit_refund,payment_fee,payment_unrelease,margin")
    private String action;

    @ApiModelProperty(value = "The related entity that created the transaction."
            , allowableValues = "conversion,payment,inbound_funds,deposit,transfer")
    private String relatedEntityType;

    @ApiModelProperty(value = "UUID of the related entity.")
    private String relatedEntityId;

    @ApiModelProperty(value = "Short reference code.")
    private String relatedEntityShortReference;

    @ApiModelProperty(value = "Transaction status.", allowableValues = "completed,pending,deleted")
    private String status;

    @ApiModelProperty(value = "Whether the transaction debits or credits the account balance.", allowableValues = "debit,credit")
    private String type;

    @ApiModelProperty(value = "User-generated reason for payment. Freeform text.")
    private String reason;

    @ApiModelProperty(value = "default clients. 'Own' account, 'clients' sub-accounts, or 'all' accounts.", allowableValues = "Own,clients,all")
    private String scope;

    @ApiModelProperty(value = "default 1")
    private String pagenNum;

    @ApiModelProperty(value = "default 25,max 25")
    private String pageSize;

}
