package com.liquidnet.service.sweet.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class SweetManualAppletMDSKDto implements Serializable ,Cloneable{
    @ApiModelProperty("电子手册id")
    private String manualId;
    @ApiModelProperty("演出id")
    private String performancesId;
    @ApiModelProperty("演出标题")
    private String title;
    @ApiModelProperty("场地id")
    private String fieldId;
    @ApiModelProperty("场地名称")
    private String fieldName;
    @ApiModelProperty("城市名称")
    private String cityName;
    @ApiModelProperty("演出开始时间")
    private String timeStart;
    @ApiModelProperty("演出结束时间")
    private String timeEnd;
    @ApiModelProperty("演出开售时间")
    private String timeSell;
    @ApiModelProperty("是否会员")
    private Integer isMember;
    @ApiModelProperty("提前时间")
    private Integer payCountdownMinute;


    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;


    private static final SweetManualAppletMDSKDto obj = new SweetManualAppletMDSKDto();
    public static SweetManualAppletMDSKDto getNew() {
        try {
            return (SweetManualAppletMDSKDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualAppletMDSKDto();
        }
    }
}
