package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2Dto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistStageListDto;
import com.liquidnet.service.sweet.entity.*;
import com.liquidnet.service.sweet.mapper.SweetArtistsMapper;
import com.liquidnet.service.sweet.mapper.SweetArtistsUrlMapper;
import com.liquidnet.service.sweet.mapper.SweetManualArtistsMapper;
import com.liquidnet.service.sweet.mapper.SweetStageMapper;
import com.liquidnet.service.sweet.param.SweetArtistsListParam;
import com.liquidnet.service.sweet.service.ISweetArtistsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetArtistsVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 艺人表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Slf4j
@Service
public class SweetArtistsServiceImpl extends ServiceImpl<SweetArtistsMapper, SweetArtists> implements ISweetArtistsService {

    @Autowired
    private SweetArtistsMapper sweetArtistsMapper;
    @Autowired
    private SweetManualArtistsMapper sweetManualArtistsMapper;
    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    private SweetArtistsUrlMapper sweetArtistsUrlMapper;


    @Override
    public ResponseDto<PageInfo<SweetArtists>> getList(int page, int size, String name) {
        PageInfo<SweetArtists> pageInfo = null;
        try {
            List<SweetArtists> data;
            PageHelper.startPage(page, size);
            if (name != null) {
                data = sweetArtistsMapper.selectList(Wrappers.lambdaQuery(SweetArtists.class).like(SweetArtists::getName, name));
            } else {
                data = sweetArtistsMapper.selectList(Wrappers.lambdaQuery(SweetArtists.class));
            }
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    @Transactional
    public ResponseDto<Boolean> add(SweetArtistsListParam sweetArtistsList) {
        try {
            String mid = IDGenerator.nextSnowId();
            LocalDateTime time = LocalDateTime.now();
            SweetArtistsUrl sweetArtistsUrl = SweetArtistsUrl.getNew();
            SweetArtists sweetArtists = SweetArtists.getNew();
            sweetArtists.setArtistsId(mid);
            sweetArtists.setName(sweetArtistsList.getName());
            sweetArtists.setPinyin(sweetArtistsList.getPinyin());
            sweetArtists.setDescribes(sweetArtistsList.getDescribes());
            sweetArtists.setPicUrl(sweetArtistsList.getPicUrl());
            sweetArtists.setCreatedAt(time);
            sweetArtists.setUpdatdAt(time);
            sweetArtistsMapper.insert(sweetArtists);
            sweetArtistsUrl.setArtistsId(mid);
            sweetArtistsUrl.setCreatedAt(time);
            if (sweetArtistsList.getPicArray() != null) {
                for (String img : sweetArtistsList.getPicArray()) {
                    sweetArtistsUrl.setUrl(img);
                    sweetArtistsUrl.setType("1");
                    sweetArtistsUrlMapper.insert(sweetArtistsUrl);
                }
            }
            if (sweetArtistsList.getVideoArray() != null) {
                for (String video : sweetArtistsList.getVideoArray()) {
                    sweetArtistsUrl.setUrl(video);
                    sweetArtistsUrl.setType("2");
                    sweetArtistsUrlMapper.insert(sweetArtistsUrl);
                }
            }
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetArtistsVo> detail(String artistsId) {
        try {
            SweetArtistsVo vo = SweetArtistsVo.getNew();
            SweetArtists sweetArtists = sweetArtistsMapper.selectOne(Wrappers.lambdaQuery(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId));

            BeanUtils.copyProperties(sweetArtists, vo);
            List<SweetArtistsUrl> sweetArtistsUrl = sweetArtistsUrlMapper.selectList(Wrappers.lambdaQuery(SweetArtistsUrl.class).eq(SweetArtistsUrl::getArtistsId, artistsId));
            vo.setSweetArtistsUrl(sweetArtistsUrl);
            return ResponseDto.success(vo);
        } catch (Exception e) {
            log.error("==", e);
            return ResponseDto.failure();
        }
    }

    @Override
    @Transactional
    public ResponseDto<Boolean> change(String artistsId, SweetArtistsListParam sweetArtistsList) {
        try {
            LocalDateTime time = LocalDateTime.now();
            SweetArtists sweetArtists = SweetArtists.getNew();
            sweetArtists.setName(sweetArtistsList.getName());
            sweetArtists.setPinyin(sweetArtistsList.getPinyin());
            sweetArtists.setPicUrl(sweetArtistsList.getPicUrl());
            sweetArtists.setDescribes(sweetArtistsList.getDescribes());
            sweetArtists.setUpdatdAt(time);
            SweetArtistsUrl sweetArtistsUrl = SweetArtistsUrl.getNew();
            sweetArtistsUrl.setCreatedAt(time);
            sweetArtistsMapper.update(sweetArtists, Wrappers.lambdaUpdate(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId));
            //更新关联表
            sweetArtistsUrlMapper.delete(Wrappers.lambdaQuery(SweetArtistsUrl.class).eq(SweetArtistsUrl::getArtistsId, artistsId));
            sweetArtistsUrl.setArtistsId(artistsId);
            sweetArtistsUrl.setCreatedAt(time);
            for (String img : sweetArtistsList.getPicArray()) {
                sweetArtistsUrl.setUrl(img);
                sweetArtistsUrl.setType("1");
                sweetArtistsUrlMapper.insert(sweetArtistsUrl);
            }
            String[] videoArray = sweetArtistsList.getVideoArray();
            if (null != videoArray && videoArray.length > 0) {
                for (String video : sweetArtistsList.getVideoArray()) {
                    sweetArtistsUrl.setUrl(video);
                    sweetArtistsUrl.setType("2");
                    sweetArtistsUrlMapper.insert(sweetArtistsUrl);
                }
            }

            List<SweetManualArtists> data = sweetManualArtistsMapper.selectList(Wrappers.lambdaQuery(SweetManualArtists.class).eq(SweetManualArtists::getArtistsId, artistsId));
            for (SweetManualArtists item : data) {
                redisDataUtils.deleteTimeListRedisData(item.getManualId());
            }
            return ResponseDto.success();
        } catch (Exception e) {
            log.error("sweetArtistsChangeExc", e);
            log.error("sweetArtistsChangeE [e:{}]", e);
            return ResponseDto.failure();
        }
    }

    @Override
    @Transactional
    public ResponseDto<SweetArtists> del(String artistsId) {
        try {
            sweetArtistsMapper.delete(Wrappers.lambdaQuery(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId));
            sweetArtistsUrlMapper.delete(Wrappers.lambdaQuery(SweetArtistsUrl.class).eq(SweetArtistsUrl::getArtistsId, artistsId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }


}
