package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreCertificationVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinStoreInfoVo", description = "店铺基础信息")
@Data
public class GoblinStoreInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -2268722236055938975L;
    @ApiModelProperty(position = 11, value = "店铺ID[64]")
    private String storeId;
    @ApiModelProperty(position = 12, value = "店主UID[64]")
    private String uid;
    @ApiModelProperty(position = 13, value = "店铺名称[128]")
    private String storeName;
    @ApiModelProperty(position = 14, value = "店铺LOGO[256]")
    private String logoPic;
    @ApiModelProperty(position = 15, value = "店铺背景图[256]")
    private String backgroundPic;
    @ApiModelProperty(position = 16, value = "店铺介绍[500]")
    private String introduce;
    @ApiModelProperty(position = 17, value = "店铺状态[0-填写资料中|1-店铺审核中|2-审核不通过|3-审核通过|4-停业|5-营业]")
    private String status;
    @ApiModelProperty(position = 18, value = "拒绝原因[256]")
    private String reason;
    @ApiModelProperty(position = 19, value = "店铺类型[1-普通店铺|2-加盟|3-连锁|5-直营]")
    private String storeType;
    @ApiModelProperty(position = 20, value = "认证类型[1-企业/公司|2-个体工商户]")
    private String certType;
    @ApiModelProperty(position = 21, value = "店铺评分[8,2]")
    private BigDecimal aveScore;
    @ApiModelProperty(position = 22, value = "客服账号[128]")
    private String serviceAcc;
    @ApiModelProperty(position = 23, value = "店铺有效期")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime validity;
    private String createdBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    private String updatedBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    @ApiModelProperty(position = 25, value = "店铺认证信息")
    private GoblinStoreCertificationVo certificationVo;


    private static final GoblinStoreInfoVo obj = new GoblinStoreInfoVo();

    public static GoblinStoreInfoVo getNew() {
        try {
            return (GoblinStoreInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreInfoVo();
        }
    }
}
