package com.liquidnet.service.feign.sweet.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-sweet",
        contextId = "FeignSweetTaskClient", path = "sweet",
        url = "${liquidnet.service.sweet.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignSweetTaskClient {

    @PostMapping("sweetData/drawLuck/add")
    ResponseDto<Boolean> drawLuckAdd();

    @GetMapping("integralActivity/setDrawAllList")
    ResponseDto<Boolean> setDrawAllList(@RequestParam("integralActivityId") String integralActivityId);
}
