package com.liquidnet.service.feign.bank.api.currencycloud;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcPaymentCreateParam;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayment;
import com.liquidnet.service.feign.bank.api.constant.FeignBankConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
@FeignClient(name = FeignBankConstant.LIQUIDNET_SERVICE_BANK,
        path = FeignBankConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignBankConstant.CONTEXT_BANK_CC_PAYMENT)
public interface FeignBankCcPaymentClient {

    /**
     * 创建currency cloud payment
     */
    @RequestMapping(value = "/bank-cc-payment/create", method = RequestMethod.POST)
    ResponseDto<BankCcPayment> create(@RequestBody BankCcPaymentCreateParam param);

}
