package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "AdamDisposedVo", description = "想去信息")
@Data
public class AdamDisposedVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 3222644230886542725L;
    @ApiModelProperty(position = 11, value = "内容ID[64]")
    private String contentId;
    @ApiModelProperty(position = 12, value = "内容类型")
    private String type;
    @ApiModelProperty(position = 13, value = "标记时间")
    private String createdAt;
    @ApiModelProperty(position = 14, value = "展示信息")
    private PerformanceVo contentInfo;
    @ApiModelProperty(position = 15, value = "想去的用户信息列表，默认三个")
    private List<AdamDisposedUserVo> userVos;

    private static final AdamDisposedVo obj = new AdamDisposedVo();

    public static AdamDisposedVo getNew() {
        try {
            return (AdamDisposedVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamDisposedVo();
        }
    }
}
