package com.liquidnet.service.kylin.dto.vo.partner;

import com.liquidnet.service.kylin.dto.param.PerformancePartnerVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class PerformancePartnerListVo {

    //演出数据
    @ApiModelProperty(value = "主键id")
    private String performancesId;
    @ApiModelProperty(value = "标题")
    private String title;
    @ApiModelProperty(value = "开演时间")
    private String timeStart;
    @ApiModelProperty(value = "结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "总库存")
    private Integer totalGeneral;
    @ApiModelProperty(value = "销售库存")
    private Integer saleGeneral;
    @ApiModelProperty(value = "总销售金额")
    private Integer totalSalePrice;
    @ApiModelProperty(value = "剩余库存")
    private Integer surplusGeneral;
    @ApiModelProperty(value = "演出状态")
    private Integer status;
    @ApiModelProperty(value = "提交审核状态 -1未提交审核，0提交审核，1审核通过，2审核拒绝")
    private Integer auditStatus;
    @ApiModelProperty(value = "拒绝理由")
    private String rejectTxt;
    @ApiModelProperty(value = "创建时间")
    private String createdAt;

    @ApiModelProperty(value = "返回数据赋值",hidden = true)
    public void setStatus0Data(PerformancePartnerVo item){
        this.performancesId=item.getPerformancesId();
        this.title=item.getTitle();
        this.timeStart=item.getTimeStart();
        this.timeEnd=item.getTimeEnd();
        this.totalGeneral=0;
        this.saleGeneral=0;
        this.totalSalePrice=0;
        this.status=0;
        this.auditStatus=-1;
        this.rejectTxt="";
        this.createdAt=item.getCreatedAt();
    }
}
