package com.liquidnet.service.kylin.controller.admin;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.RoadShowAdminListDao;
import com.liquidnet.service.kylin.dto.param.CreateRoadShowParam;
import com.liquidnet.service.kylin.dto.vo.admin.RoadShowAdminVo;
import com.liquidnet.service.kylin.service.impl.admin.KylinRoadShowsAdminServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 巡演 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Api(tags = "后端-巡演",position = 2002)
@RestController
@RequestMapping("/admin/roadshow")
public class KylinRoadShowsAdminController {

    @Autowired
    private KylinRoadShowsAdminServiceImpl roadShowsService;

    @GetMapping(value = "list")
    @ApiOperation(value = "获取列表",position = 1)
    @ApiResponse(response = RoadShowAdminListDao.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<RoadShowAdminListDao>> listRoadShow(@RequestParam(value = "title",required = false) String title,
                                                                          @RequestParam(value = "page") int page,
                                                                          @RequestParam(value = "size") int size) {
        PageInfo<RoadShowAdminListDao> result = null;
        result = roadShowsService.listRoadShow(title, page, size);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出详情失败");
        }
    }

    @PostMapping(value = "")
    @ApiOperation(value = "创建",position = 2)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Map<String,String>> createRoadShow(@RequestBody CreateRoadShowParam createRoadShowParam) {
        String result = roadShowsService.createRoadShow(createRoadShowParam);
        if (!result.isEmpty()) {
            Map<String,String> map = new HashMap<>();
            map.put("roadShowId",result);
            return ResponseDto.success(map);
        } else {
            return ResponseDto.failure("创建失败");
        }
    }

    @PutMapping(value = "")
    @ApiOperation(value = "修改",position = 3)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> updateRoadShow(@RequestBody CreateRoadShowParam createRoadShowParam) {
        boolean result = roadShowsService.updateRoadShow(createRoadShowParam);
        if (result) {
            return ResponseDto.success("修改成功");
        } else {
            return ResponseDto.failure("修改失败");
        }
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除",position = 4)
    @ApiResponse( code = 200, message = "接口返回对象参数")
    public ResponseDto<String> deleteRoadShow(@RequestParam("roadShowId") String roadShowId, @RequestParam("status") int status) {
        boolean result = roadShowsService.deleteRoadShow(roadShowId, status);
        if (result) {
            return ResponseDto.success("操作成功");
        } else {
            return ResponseDto.failure("操作失败");
        }
    }

    @GetMapping(value = "details")
    @ApiOperation(value = "详情",position = 5)
    @ApiResponse(response = RoadShowAdminVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<RoadShowAdminVo> detailsRoadShow(@RequestParam("roadShowId") String roadShowId) {
        RoadShowAdminVo result = null;
        result = roadShowsService.detailsRoadShow(roadShowId);
        if (result != null) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("操作失败");
        }
    }
}
