package com.liquidnet.service.sweet.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel
public class SweetManualArtistStageListArDto implements Serializable, Cloneable {

    private static final long serialVersionUID = 4113494130809902656L;

    @ApiModelProperty("舞台名称")
    private String title;
    @ApiModelProperty("舞台ID")
    private String stageId;
    @ApiModelProperty("艺人数据")
    private List<SweetManualArtistListArDto> artistList;

    private static final SweetManualArtistStageListArDto obj = new SweetManualArtistStageListArDto();

    public static SweetManualArtistStageListArDto getNew() {
        try {
            return (SweetManualArtistStageListArDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualArtistStageListArDto();
        }
    }
}
