package com.liquidnet.service.merchant.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 主办申请表
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MerchantSponsorApplies implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * sponsor_apply_id
     */
    private String sponsorApplyId;

    /**
     * 申请状态 0待审核 1通过 2驳回
     */
    private Integer applyStatus;

    /**
     * 类型 create创建
     */
    private String applyType;

    /**
     * 驳回原因
     */
    private String reject;

    /**
     * 申请者账号
     */
    private String uid;

    /**
     * 名称
     */
    private String name;

    /**
     * logo图片地址
     */
    private String logo;

    /**
     * 背景图片地址
     */
    private String background;

    /**
     * 介绍
     */
    private String description;

    /**
     * 联系人姓名
     */
    private String contactName;

    /**
     * 联系人身份证号码
     */
    private String contactIdentity;

    /**
     * 联系人身份证正面照
     */
    private String contactIdentityObverse;

    /**
     * 联系人身份证反面照
     */
    private String contactIdentityReverse;

    /**
     * 联系人邮箱
     */
    private String contactEmail;

    /**
     * 企业名称
     */
    private String companyName;

    /**
     * 营业执照编号
     */
    private String licenseCode;

    /**
     * 营业执照图片地址
     */
    private String licenseImg;

    /**
     * 法人姓名
     */
    private String legalName;

    /**
     * 法人身份证号码
     */
    private String legalIdentity;

    /**
     * 法人身份证正面照
     */
    private String legalIdentityObverse;

    /**
     * 法人身份证反面照
     */
    private String legalIdentityReverse;

    /**
     * 审核人ID
     */
    private String auditUid;

    /**
     * 审核人姓名
     */
    private String auditName;

    private LocalDateTime auditedAt;

    private LocalDateTime deletedAt;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
