package com.liquidnet.service.kylin.dto.param.ticketSystem;

import com.liquidnet.service.kylin.dto.vo.ticketSystem.STFieldListVo;
import com.liquidnet.service.kylin.dto.vo.ticketSystem.TicketVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "STInsertTicketParam", description = "详情")
public class STInsertTicketParam implements Cloneable{
    @ApiModelProperty(value = "演出ID [必传]")
    String performanceId;
    @ApiModelProperty(value = "场次id [必传]")
    String sessionId;
    @ApiModelProperty(value = "场次编码 [必传]")
    String sessionCode;
    @ApiModelProperty(value = "票价ID [必传]")
    String priceId;
    @ApiModelProperty(value = "票List [必传]")
    List<TicketVo> ticketList;

    private static final STInsertTicketParam obj = new STInsertTicketParam();

    public static STInsertTicketParam getNew() {
        try {
            return (STInsertTicketParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new STInsertTicketParam();
    }
}