package com.liquidnet.service.chime.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "ChimeTagVo", description = "标签库")
public class ChimeTagVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 5852327873275898342L;

    @ApiModelProperty(position = 0, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 11, value = "标签Key")
    private String tagCode;
    @ApiModelProperty(position = 12, value = "标签名称")
    private String tagDesc;

    private static final ChimeTagVo obj = new ChimeTagVo();

    public static ChimeTagVo getNew() {
        try {
            return (ChimeTagVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new ChimeTagVo();
    }
}
