package com.liquidnet.service.slime.service.impl;

import com.liquidnet.service.slime.dto.vo.*;
import com.liquidnet.service.slime.service.ISlimeStationsService;
import com.liquidnet.service.slime.service.SlimeRdmService;
import com.liquidnet.service.slime.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;

@Slf4j
@Service
public class SlimeStationsServiceImpl implements ISlimeStationsService {

    @Autowired
    SlimeRdmService slimeRdmService;

    @Override
    public List<SlimeStationsVo> stationsList(String uid) {

        List<SlimeStationsVo> vos = ObjectUtil.getSlimeStationsVosArrayList();

        List<SlimeFieldAppliesVo> fieldAppliesVos = slimeRdmService.getFieldAppliesVosByUid(uid);
        if (!CollectionUtils.isEmpty(fieldAppliesVos)) {
            for (SlimeFieldAppliesVo fieldAppliesVo : fieldAppliesVos) {
                SlimeStationsVo vo = SlimeStationsVo.getNew();
                if (1 == fieldAppliesVo.getApplyStatus()) {
                    SlimeFieldsVo fieldsVo = slimeRdmService.getFieldsVoByFieldId(fieldAppliesVo.getFieldId());
                    vo.setStationType("field");
                    vo.setApplyStatus(fieldAppliesVo.getApplyStatus());
                    vo.setApplyType(fieldAppliesVo.getApplyType());
                    vo.setReject(fieldAppliesVo.getReject());
                    vo.setName(fieldsVo.getName());
                    vo.setLogo(fieldsVo.getLogo());
                    vo.setFieldApplyId(fieldAppliesVo.getFieldApplyId());
                    vo.setFieldId(fieldAppliesVo.getFieldId());
                    vo.setCreatedAt(fieldsVo.getCreatedAt());
                    vo.setUpdatedAt(fieldsVo.getUpdatedAt());
                } else {
                    vo.setStationType("fieldApply");
                    vo.setApplyStatus(fieldAppliesVo.getApplyStatus());
                    vo.setApplyType(fieldAppliesVo.getApplyType());
                    vo.setReject(fieldAppliesVo.getReject());
                    vo.setName(fieldAppliesVo.getName());
                    vo.setLogo(fieldAppliesVo.getLogo());
                    vo.setFieldApplyId(fieldAppliesVo.getFieldApplyId());
                    vo.setFieldId(fieldAppliesVo.getFieldId());
                    vo.setCreatedAt(fieldAppliesVo.getCreatedAt());
                    vo.setUpdatedAt(fieldAppliesVo.getUpdatedAt());
                }
                vos.add(vo);
            }
        }

        List<SlimeSponsorAppliesVo> sponsorAppliesVos = slimeRdmService.getSponsorAppliesVosByUid(uid);
        if (!CollectionUtils.isEmpty(sponsorAppliesVos)) {
            for (SlimeSponsorAppliesVo sponsorAppliesVo : sponsorAppliesVos) {
                SlimeStationsVo vo = SlimeStationsVo.getNew();
                if (1 == sponsorAppliesVo.getApplyStatus()) {
                    SlimeSponsorsVo sponsorsVo = slimeRdmService.getSponsorsVoBySponsorId(sponsorAppliesVo.getSponsorId());
                    vo.setStationType("sponsor");
                    vo.setApplyStatus(sponsorAppliesVo.getApplyStatus());
                    vo.setApplyType(sponsorAppliesVo.getApplyType());
                    vo.setReject(sponsorAppliesVo.getReject());
                    vo.setName(sponsorsVo.getName());
                    vo.setLogo(sponsorsVo.getLogo());
                    vo.setSponsorApplyId(sponsorAppliesVo.getSponsorApplyId());
                    vo.setSponsorId(sponsorAppliesVo.getSponsorId());
                    vo.setCreatedAt(sponsorsVo.getCreatedAt());
                    vo.setUpdatedAt(sponsorsVo.getUpdatedAt());
                } else {
                    vo.setStationType("sponsorApply");
                    vo.setApplyStatus(sponsorAppliesVo.getApplyStatus());
                    vo.setApplyType(sponsorAppliesVo.getApplyType());
                    vo.setReject(sponsorAppliesVo.getReject());
                    vo.setName(sponsorAppliesVo.getName());
                    vo.setLogo(sponsorAppliesVo.getLogo());
                    vo.setSponsorApplyId(sponsorAppliesVo.getSponsorApplyId());
                    vo.setSponsorId(sponsorAppliesVo.getSponsorId());
                    vo.setCreatedAt(sponsorAppliesVo.getCreatedAt());
                    vo.setUpdatedAt(sponsorAppliesVo.getUpdatedAt());
                }
                vos.add(vo);
            }
        }

        vos.sort(Comparator.comparing(SlimeStationsVo::getCreatedAt).reversed());

        return vos;
    }
}
