package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyUserBindStatusQueryReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 12:06
 */
@ApiModel(value = "GalaxyUserBindStatusQueryReqDto", description = "用户绑定状态查询")
@Data
public class GalaxyUserBindStatusQueryReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    /**
     * nftOrderPayId
     */
    @ApiModelProperty(position = 1, required = true, value = "用户区块链地址")
    @NotBlank(message = "用户区块链地址不能为空！")
    @Size(min = 2, max = 100, message = "用户区块链地址不能超过100个字符")
    private String blockChainAddress;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyUserBindStatusQueryReqDto obj = new GalaxyUserBindStatusQueryReqDto();

    public static GalaxyUserBindStatusQueryReqDto getNew() {
        try {
            return (GalaxyUserBindStatusQueryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyUserBindStatusQueryReqDto();
        }
    }
}
