package com.liquidnet.service.consumer.order.receiver;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamListener;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.*;

@Slf4j
public abstract class AbstractHttpRedisReceiver implements StreamListener<String, MapRecord<String, String, String>> {

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Value("${liquidnet.service.order.url}")
    private String orderUrl;

    @Override
    public void onMessage(MapRecord<String, String, String> message) {
        String redisStreamKey = this.getRedisStreamKey();
        log.debug("CONSUMER MSG[streamKey:{},messageId:{},stream:{},body:{}]", redisStreamKey, message.getId(), message.getStream(), message.getValue());
        boolean result = this.consumerMessageHandler(message.getValue());
        log.info("CONSUMER MSG RESULT:{} ==> [{}]MESSAGE_ID:{}", result, redisStreamKey, message.getId());

        try {
            stringRedisTemplate.opsForStream().acknowledge(getRedisStreamGroup(), message);
        } catch (Exception e) {
            log.error("#CONSUMER MSG EX_ACK ==> [{}]RESULT:{},MESSAGE:{}", redisStreamKey, result, message.getValue(), e);
        }
        try {
            stringRedisTemplate.opsForStream().delete(redisStreamKey, message.getId());
        } catch (Exception e) {
            log.error("#CONSUMER MSG EX_DEL ==> [{}]RESULT:{},MESSAGE:{}", redisStreamKey, result, message.getValue(), e);
        }
    }

    private boolean consumerMessageHandler(Map<String, String> message) {
        try {
            String codestr = message.get("codes");
            String userIds = message.get("userIds");
            String phonestr = message.get("phones");
            String adminUid = message.get("adminUid");
            List<String> codeList = Arrays.asList(codestr.split(","));
            List<String> userIdList = Arrays.asList(userIds.split(","));
            List<String> phoneList = Arrays.asList(phonestr.split(","));
            LinkedList<Object[]> addLink = CollectionUtil.linkedListObjectArr();
            for (int i = 0; i < userIdList.size(); i++) {
                MultiValueMap<String, String> params = new LinkedMultiValueMap();
                params.add("code", codeList.get(i));
                params.add("userId", userIdList.get(i));
                MultiValueMap<String, String> headers = CollectionUtil.linkedMultiValueMapStringString();
                headers.add("Accept", "application/json;charset=UTF-8");
                String post = HttpUtil.post(orderUrl + "/order/goblin/nft/airdrop", params, headers);
                ResponseDto<Boolean> rsp = JsonUtils.fromJson(post, new TypeReference<ResponseDto<Boolean>>() {
                });
                if (rsp.isSuccess()) {
                    addLink.add(new Object[]{adminUid, codeList.get(i)});
                } else {
                    log.error("airdrop send fail:[{}]" + phoneList.get(i));
                }
            }

            if (addLink != null && !addLink.isEmpty()) {
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                sqls.add(SqlMapping.get("goblin_activity.code.admin"));
                String sqlData = SqlMapping.gets(sqls, addLink);
                sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_CODE_OPERA.getKey(), sqlData);
            }

        } catch (Exception e) {
            log.error("airdrop send fail:[{}]");
        }

        return true;
    }


    public void sendMsgByRedis(String streamKey, String jsonMsg) {
        HashMap<String, String> map = CollectionUtil.mapStringString();
        map.put(MQConst.QUEUE_MESSAGE_KEY, jsonMsg);
        stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
    }


    protected abstract String getRedisStreamKey();

    protected abstract String getRedisStreamGroup();


}
