package com.liquidnet.client.admin.common.enums;

import java.util.*;

/**
 * <p>
 * 友盟推送 跳转类型
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-13
 */
public enum UpushTargetType {

    TARGET_TYPE0("打开APP", 0, "go_app"),
    TARGET_TYPE16("演出首页", 16, "ticket_home"),
    TARGET_TYPE17("商城首页", 17, "goods_home"),

//    TARGET_TYPE5("场地详情", 5, "area"),
    TARGET_TYPE6("票务详情", 6, "ticket"),
    TARGET_TYPE7("商品详情", 7, "goods"),
    TARGET_TYPE14("商品集合", 14, "goods_collection"),
//    TARGET_TYPE20("音乐人详情", 20, "musician"),
//    TARGET_TYPE24("音乐人集合", 24, "musician_collection"),
//    TARGET_TYPE21("歌曲详情", 21, "song"),
//    TARGET_TYPE22("专辑详情", 22, "album"),
    TARGET_TYPE26("摩登会员", 26, "member"),

    TARGET_TYPE12("活动跳转-可分享", 12, "ad_link"),
    TARGET_TYPE100("活动跳转", 100, "promotion"),

//    TARGET_TYPE28("消息列表", 28, "area),
    TARGET_TYPE32("系统消息列表", 32, "show_message_list");
//    TARGET_TYPE33("会员消息列表", 33);

    private String name;
    private int index;
    private String action;

    UpushTargetType(String name, int index, String action) {
        this.name = name;
        this.index = index;
        this.action = action;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getAction() {
        return this.action;
    }

    private static List<Object> resultTypeListR = null;

    static {
        ArrayList<Object> resultTypeList = new ArrayList<>();
        for (UpushTargetType resultType : UpushTargetType.values()) {
            Map<String, Object> mapTemp = new HashMap<>();
            mapTemp.put("id", resultType.index);
            mapTemp.put("name", resultType.name);
            mapTemp.put("action", resultType.action);
            resultTypeList.add(mapTemp);
        }
        resultTypeListR = Collections.unmodifiableList(resultTypeList);
    }

    public static List<Object> getResultType() {
        return resultTypeListR;
    }

    public static String getTypeName(int index) {
        for (UpushTargetType c : UpushTargetType.values()) {
            if (c.getIndex() == index) {
                return c.name;
            }
        }
        return null;
    }

    public static String getTypeAction(int index) {
        for (UpushTargetType c : UpushTargetType.values()) {
            if (c.getIndex() == index) {
                return c.action;
            }
        }
        return null;
    }
}
