package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.domain.KylinOrderTickets;
import com.liquidnet.client.admin.zhengzai.kylin.service.IKylinOrderTicketsService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 订单Controller
 * 
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/tickets")
public class KylinOrderTicketsController extends BaseController
{
    private String prefix = "zhengzai/kylin/tickets";

    @Autowired
    private IKylinOrderTicketsService kylinOrderTicketsService;

    @RequiresPermissions("kylin:tickets:view")
    @GetMapping()
    public String tickets()
    {
        return prefix + "/tickets";
    }

    /**
     * 查询订单列表
     */
    @RequiresPermissions("kylin:tickets:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(KylinOrderTickets kylinOrderTickets)
    {
        startPage();
        List<KylinOrderTickets> list = kylinOrderTicketsService.selectKylinOrderTicketsList(kylinOrderTickets);
        return getDataTable(list);
    }

    /**
     * 导出订单列表
     */
    @RequiresPermissions("kylin:tickets:export")
    @Log(title = "订单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    @ResponseBody
    public AjaxResult export(KylinOrderTickets kylinOrderTickets)
    {
        List<KylinOrderTickets> list = kylinOrderTicketsService.selectKylinOrderTicketsList(kylinOrderTickets);
        ExcelUtil<KylinOrderTickets> util = new ExcelUtil<KylinOrderTickets>(KylinOrderTickets.class);
        return util.exportExcel(list, "订单数据");
    }

    /**
     * 新增订单
     */
    @GetMapping("/add")
    public String add()
    {
        return prefix + "/add";
    }

    /**
     * 新增保存订单
     */
    @RequiresPermissions("kylin:tickets:add")
    @Log(title = "订单", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    @ResponseBody
    public AjaxResult addSave(KylinOrderTickets kylinOrderTickets)
    {
        return toAjax(kylinOrderTicketsService.insertKylinOrderTickets(kylinOrderTickets));
    }

    /**
     * 修改订单
     */
    @GetMapping("/edit/{mid}")
    public String edit(@PathVariable("mid") Integer mid, ModelMap mmap)
    {
        KylinOrderTickets kylinOrderTickets = kylinOrderTicketsService.selectKylinOrderTicketsById(mid);
        mmap.put("kylinOrderTickets", kylinOrderTickets);
        return prefix + "/edit";
    }

    /**
     * 修改保存订单
     */
    @RequiresPermissions("kylin:tickets:edit")
    @Log(title = "订单", businessType = BusinessType.UPDATE)
    @PostMapping("/edit")
    @ResponseBody
    public AjaxResult editSave(KylinOrderTickets kylinOrderTickets)
    {
        return toAjax(kylinOrderTicketsService.updateKylinOrderTickets(kylinOrderTickets));
    }

    /**
     * 删除订单
     */
    @RequiresPermissions("kylin:tickets:remove")
    @Log(title = "订单", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    @ResponseBody
    public AjaxResult remove(String ids)
    {
        return toAjax(kylinOrderTicketsService.deleteKylinOrderTicketsByIds(ids));
    }
}
