package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinRechargeWristbandVo;
import com.liquidnet.service.goblin.dto.vo.MaiZhiAllVo.*;
import com.liquidnet.service.goblin.service.IGoblinRechargeWristbandService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Slf4j
@Api(tags = "充值金额")
@RestController
@Validated
@RequestMapping("/recharge")
public class GoblinRechargeAmountController {

    @Autowired
    private IGoblinRechargeWristbandService iGoblinRechargeWristbandService;


    @GetMapping("goods/list")
    @ApiOperation("获得金额列表")
    public ResponseDto<GoblinRechargeWristbandVo> getList() {
        return ResponseDto.success(iGoblinRechargeWristbandService.getList());
    }

    @PostMapping("auth")
    @ApiOperation("二要素认证")
    public ResponseDto<String> auth(@RequestBody IdCardParam param) {
        CheckIdcardResponse res = iGoblinRechargeWristbandService.auth(param);
        if (null != res && res.getErrcode() == 200) {
            return ResponseDto.success(res.getMessage());
        } else {
            return ResponseDto.failure(res.getMsg());
        }
    }

    /*@PostMapping("order/create")
    @ApiOperation("创建订单")
    public ResponseDto<String> createOrder(@RequestBody OrderParam param) {
        OrderResponse res = iGoblinRechargeWristbandService.createOrder(param);
        if (null != res && res.getErrcode() == 200) {
            return ResponseDto.success(res.getMsg());
        } else {
            return ResponseDto.failure(res.getMsg());
        }
    }*/

    /*@PostMapping("order/info")
    @ApiOperation("订单查询")
    public ResponseDto<List<OrderInfoResponse.OrderList>> getOrder(@RequestBody OrderInfoParam param) {
        OrderInfoResponse res = iGoblinRechargeWristbandService.getOrder(param);
        if (null != res && res.getErrcode() == 200) {
            return ResponseDto.success(res.getOutlist());
        } else {
            return ResponseDto.failure();
        }
    }*/

    @GetMapping("order/qrcode")
    @ApiOperation("获取二维码字符串")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "param", required = true, name = "outno", value = "分订单号"),
    })
    public ResponseDto<String> getQrcode(@NotBlank(message = "参数无效:outno") @RequestParam("outno") String outno) {
        GenerateDeviceCodeResponse res = iGoblinRechargeWristbandService.getQrcode(outno);
        if (null != res && res.getErrcode() == 200) {
            return ResponseDto.success(res.getQrcode_str());
        } else {
            return ResponseDto.failure();
        }
    }

    /*@GetMapping("device/mumber")
    @ApiOperation("获取设备编号列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "param", required = true, name = "operationNo", value = "活动号"),
    })
    public ResponseDto<Boolean> getDeviceNumber(
            @NotNull(message = "参数无效") @RequestParam("operationNo") Integer operationNo
    ) {
        Boolean res = iGoblinRechargeWristbandService.getDeviceNumber(operationNo);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure();
        }
    }*/

    @GetMapping("device/balance")
    @ApiOperation("获取余额")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "param", required = true, name = "cardno", value = "设备编号"),
    })
    public ResponseDto<BigDecimal> getDeviceBalance(
            @NotBlank(message = "参数无效:cardno") @RequestParam("cardno") String cardno
    ) {
        DeviceBalanceResponse res = iGoblinRechargeWristbandService.getDeviceBalance(cardno);
        if (null != res && res.getErrcode() == 200) {
            return ResponseDto.success(res.getMoney());
        } else {
            return ResponseDto.failure(res.getMsg());
        }
    }

    @GetMapping("device/record")
    @ApiOperation("获取设备记录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "param", required = true, name = "cardno", value = "设备编号"),
            @ApiImplicitParam(type = "param", required = true, name = "page", value = "分页"),
    })
    public ResponseDto<DeviceRecordResponse> getDeviceRecord(
            @NotBlank(message = "参数无效:cardno") @RequestParam("cardno") String cardno,
            @NotNull(message = "参数无效:page") @RequestParam("page") Integer page
    ) {
        DeviceRecordResponse res = iGoblinRechargeWristbandService.getDeviceRecord(cardno, page);
        if (null != res && res.getErrcode() == 200) {
            return ResponseDto.success(res);
        } else {
            return ResponseDto.failure(res.getMsg());
        }
    }

    @GetMapping("order/refund/apply")
    @ApiOperation("退款申请")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "param", required = true, name = "orderId", value = "订单编号"),
    })
    public ResponseDto<ChangeDeviceStatusResponse> refundApply(
            @NotBlank(message = "参数无效:orderId") @RequestParam("orderId") String orderId
    ) {
        ChangeDeviceStatusResponse res = iGoblinRechargeWristbandService.changeDeviceStatus(orderId, 1);
        if (null != res && res.getErrcode() == 200) {
            return ResponseDto.success(res);
        } else {
            return ResponseDto.failure(res.getMsg());
        }
    }

    /*@GetMapping("order/refund/result")
    @ApiOperation("退款结果查询")
    public ResponseDto<Boolean> refundRes() {
        Boolean res = iGoblinRechargeWristbandService.refundRes();
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure();
        }
    }*/

}
