package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinRechargeAmountVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = " 金额ID")
    private String amountId;

    @ApiModelProperty(value = "金额名称")
    private String name;

    @ApiModelProperty(value = "充值金额")
    private BigDecimal price;

    private final static GoblinRechargeAmountVo obj = new GoblinRechargeAmountVo();

    public static GoblinRechargeAmountVo getNew() {
        try {
            return (GoblinRechargeAmountVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinRechargeAmountVo();
        }
    }

}
