package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinExpressModuleVo;
import com.liquidnet.service.kylin.service.IKylinExpressModuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 快递模板表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-15
 */
@Api(tags = "快递模板")
@RestController
@RequestMapping("expressModule")
@Slf4j
public class KylinExpressModuleController {

    @Autowired
    private IKylinExpressModuleService expressModuleService;

    @GetMapping("")
    @ApiOperation("快递模板列表")
    public ResponseDto<List<KylinExpressModuleVo>> expressList() {
        try {
            List<KylinExpressModuleVo> result = expressModuleService.expressList();
            return ResponseDto.success(result);
        } catch (Exception e) {
            log.error("快递模板列表Error e{}", e);
            return ResponseDto.success(new ArrayList<>());
        }
    }
}
