package com.liquidnet.service.candy.dto;

import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyUserCoupon;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class CandyUserCouponBasicDto implements Serializable {
    private static final long serialVersionUID = 4073256621782131605L;

    /* com.liquidnet.service.candy.entity.CandyCoupon */
    private String couponId;
    //private Integer state;
    private String title;
    private String label;
    private String notice;
    private Integer exclusive;
    private Integer busiType;
    private Integer couType;
    private Integer bindType;
    private BigDecimal discount;
    private BigDecimal valFace;
    private BigDecimal valOver;
    private BigDecimal valMinus;
    private Integer overlay;
    private Integer overlayLevel;
    private Integer validity;
    private Integer redeemValidity;
    private LocalDateTime redeemStart;
    private LocalDateTime redeemStop;
    private LocalDateTime effectAt;
    private LocalDateTime expireAt;
    //private String operator;
    //private Date createdAt;
    //private Date updatedAt;
    //private String comment;

    /* com.liquidnet.service.candy.entity.CandyUserCoupon */
    private String ucouponId;
    //private String mcouponId;
    private String uid;
    //private String couponId;
    private Integer state;
    private String ccode;
    private LocalDateTime bindAt;
    private LocalDateTime usedAt;
    private String usedFor;
    //private String comment;

    /* com.liquidnet.service.candy.entity.CandyCouponRule */
    private List<CandyCouponRuleDto> useRules;

    
    private static final CandyUserCouponBasicDto obj = new CandyUserCouponBasicDto();

    public static CandyUserCouponBasicDto getNew() {
        try {
            return (CandyUserCouponBasicDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyUserCouponBasicDto();
        }
    }

    public CandyUserCouponBasicDto copy(CandyUserCoupon userCoupon, CandyCoupon coupon, List<CandyCouponRuleDto> couponRuleDtoList) {
        if (null == userCoupon) return this;
        this.setCouponId(coupon.getCouponId());
        this.setTitle(coupon.getTitle());
        this.setLabel(coupon.getLabel());
        this.setNotice(coupon.getNotice());
        this.setExclusive(coupon.getExclusive());
        this.setBusiType(coupon.getBusiType());
        this.setCouType(coupon.getCouType());
        this.setBindType(coupon.getBindType());
        this.setDiscount(coupon.getDiscount());
        this.setValFace(coupon.getValFace());
        this.setValOver(coupon.getValOver());
        this.setValMinus(coupon.getValMinus());
        this.setOverlay(coupon.getOverlay());
        this.setOverlayLevel(coupon.getOverlayLevel());
        this.setValidity(coupon.getValidity());
        this.setRedeemValidity(coupon.getRedeemValidity());
        this.setRedeemStart(coupon.getRedeemStart());
        this.setRedeemStop(coupon.getRedeemStop());
        this.setEffectAt(coupon.getEffectAt());
        this.setExpireAt(coupon.getExpireAt());

        this.setUcouponId(userCoupon.getUcouponId());
        this.setUid(userCoupon.getUid());
        this.setState(userCoupon.getState());
        this.setCcode(userCoupon.getCcode());
        this.setBindAt(userCoupon.getBindAt());
        this.setUsedAt(userCoupon.getUsedAt());
        this.setUsedFor(userCoupon.getUsedFor());

        this.setUseRules(couponRuleDtoList);
        return this;
    }
}
