package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberOrderCodeParam", description = "使用兑换码入参")
@Data
public class AdamMemberOrderCodeParam implements Serializable {
    private static final long serialVersionUID = 2500742355642406263L;
    @ApiModelProperty(position = 10, required = true, value = "类型:2-会员码,3-礼包码", example = "3")
    private Integer type;
    @ApiModelProperty(position = 11, required = true, value = "兑换码", example = "0")
    private String memberCode;
    @ApiModelProperty(position = 12, required = true, value = "生日", example = "2021-05-27")
    private String birthday;
    @ApiModelProperty(position = 13, required = false, value = "姓名")
    private String name;
    @ApiModelProperty(position = 14, required = false, value = "身份证件号")
    private String idCard;
}
